#include <objbase>
#include <Dbt>
#include <windows>
#include <iostream>
using namespace std;

static GUID GUID_DEVINTERFACE_USB_DEVICE =
{0xA5DCBF10, 0x6530, 0x11D2, {0x90, 0x1F, 0x00, 0xC0,
                              0x4F, 0xB9, 0x51, 0xED}};

//---------------------------------------------------------
bool hidDeviceNotify(HWND hwnd, GUID GUID_DEVINTERFACE_HID,
                     HDEVNOTIFY *hidDeviceNotify)
{
    DEV_BROADCAST_DEVICEINTERFACE NotificationFilter;
    ZeroMemory(&NotificationFilter, sizeof(NotificationFilter));
    NotificationFilter.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
    NotificationFilter.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
    NotificationFilter.dbcc_classguid = GUID_DEVINTERFACE_USB_DEVICE;
    *hidDeviceNotify = RegisterDeviceNotification(hwnd, &NotificationFilter,
                                               DEVICE_NOTIFY_WINDOW_HANDLE);
    if(!hidDeviceNotify)
    	return false;

    return true;
}
//---------------------------------------------------------
LRESULT CALLBACK WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam,
                            LPARAM lParam)
{
    switch(uMsg) {
      case WM_DEVICECHANGE:
         cout << "Jedno z urzadzen USB zostalo odlaczone/przylaczone!\n";
         break;
      default:
         return DefWindowProc(hwnd, uMsg, wParam, lParam);
    }
    return 0;
}
//---------------------------------------------------------
int main()
{
    const char * const className = "DeviceNotifyTest";
    HDEVNOTIFY hDeviceNotify;

    WNDCLASS wincl = {0};
    wincl.hInstance = GetModuleHandle(0);
    wincl.lpszClassName = className;
    wincl.lpfnWndProc = WindowProc;

    if (!RegisterClass(&wincl)) {
        DWORD error = GetLastError();
        cout << "Bdne wykonanie RegisterClass(), error = " << error << endl;
        return 1;
    }

    HWND hwnd = CreateWindowEx(0, className, className,
                               0, 0, 0, 0, 0, 0, 0, 0, 0);
    if (!hwnd) {
        DWORD error = GetLastError();
        cout << "Bdne wykonanie CreateWindowEx(), error = " << error << endl;
        return 1;
    }
    if(!hidDeviceNotify(NULL, GUID_DEVINTERFACE_USB_DEVICE, &hDeviceNotify)){
       cout << "Bad wykonania funkcji hidDeviceNotify().\n";
      return 1;
    }
    cout << "Funkcja hidDeviceNotify() wykonana pomyslnie.\n";

    cout << "Oczekiwanie na powiadamianie o odlaczaniu/"
            "przylaczaniu urzadzenia.\n"
            "Aby zakonczyc program nacisnij Ctrl-C\n" << endl;

    for (;;)
    {
        MSG msg;
        BOOL bRet = GetMessage(&msg, hwnd, 0, 0);
        if ((bRet == 0) || (bRet == -1))
            break;

        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return 0;
}
//---------------------------------------------------------
 
